from prompta.utils.java_libs import Word

class DefaultQuery:

    def __init__(self, *args, **kwargs):
        output = None
        if len(args) == 1:
            if 'Word' in str(type(args[0])):
                prefix = Word.epsilon()
                suffix = args[0]
            elif isinstance(args[0], DefaultQuery):
                prefix = args[0].get_prefix()
                suffix = args[0].get_suffix()
                output = args[0].get_output()
            else:
                prefix = args[0].getPrefix()
                suffix = args[0].getSuffix()
                output = args[0].getOutput()
        elif len(args) == 2:
            if 'Word' in str(type(args[0])) and 'Word' in str(type(args[1])):
                prefix = args[0]
                suffix = args[1]
            elif 'Word' in str(type(args[0])):
                prefix = Word.epsilon()
                suffix = args[0]
                output = args[1]
        elif len(args) == 3:
            if 'Word' in str(type(args[0])) and 'Word' in str(type(args[1])):
                prefix = args[0]
                suffix = args[1]
                output = args[2]

        self.prefix = prefix
        self.suffix = suffix
        self.output = output

    def get_input(self):
        return self.get_prefix().concat(self.get_suffix())

    def get_prefix(self):
        """Returns the prefix of the query."""
        return self.prefix

    def get_suffix(self):
        """Returns the suffix of the query."""
        return self.suffix

    def get_output(self):
        """Returns the output of the query."""
        return self.output

    def answer(self, output):
        """Answers the query by setting the output."""
        self.output = output

    def is_normalized(self) -> bool:
        """Checks if the query is normalized, i.e., all information is in the suffix."""
        return self.prefix.isEmpty()

    def to_string_with_answer(self, answer) -> str:
        """Returns a string representation of the query, including the answer."""
        return f"Query[{self.prefix}|{self.suffix} / {answer}]"

    def __str__(self):
        """Returns a string representation of the query, using the output."""
        return self.to_string_with_answer(self.output)